(function($){
    function wcrez_log($el, msg, ok){
        $el.html(
            '<div class="' + (ok ? 'notice notice-success' : 'notice notice-error') + '" style="padding:10px;margin:0;"><p>' +
            msg +
            '</p></div>'
        );
    }

    $(document).on('click', '#wcrez-send-full,#wcrez-recv-full,#wcrez-send-price,#wcrez-recv-price', function(e){
        e.preventDefault();

        var id     = $(this).attr('id');
        var action = 'wcrez_push';

        if (id === 'wcrez-send-full') {
            action = 'wcrez_push';
        } else if (id === 'wcrez-recv-full') {
            action = 'wcrez_pull';
        } else if (id === 'wcrez-send-price') {
            action = 'wcrez_push_price';
        } else if (id === 'wcrez-recv-price') {
            action = 'wcrez_pull_price';
        }

        var postId = $('#post_ID').val();
        var remote = $('#wcrez-remote').val();
        var token  = $('#wcrez-token').val();
        var $msg   = $('#wcrez-msg');

        if (!remote || !token) {
            wcrez_log($msg, 'لطفاً ابتدا در تنظیمات افزونه، Remote URL و Token را وارد کنید.', false);
            return;
        }

        $msg.html('در حال ارتباط با سایت مقابل...');

        $.post(WCREZ.ajax, {
            action: action,
            nonce:  WCREZ.nonce,
            post_id: postId,
            remote:  remote,
            token:   token
        }).done(function(resp){
            if (resp && resp.success) {
                wcrez_log($msg, resp.data && resp.data.message ? resp.data.message : 'انجام شد.', true);
            } else {
                var msg = (resp && resp.data && resp.data.message) ? resp.data.message : 'خطای نامشخص.';
                wcrez_log($msg, msg, false);
            }
        }).fail(function(xhr){
            wcrez_log($msg, 'خطا در اتصال به AJAX / سرور.', false);
        });
    });
})(jQuery);
